@extends('theme::layouts.public')

@section('content')

    <div id="checkout">

        @if(! $basket->exists || $basket->items->isEmpty())
            <div class="emptyBasket">
                <h1>{{ trans('shop::basket.empty') }}</h1>
            </div>
        @else
            <basket basket-in="{{ $basket }}"
                inline-template
                v-cloak>
                <form class="checkoutForm" action="{{ route('shop.basket.update') }}" method="post">
                    {{ csrf_field() }}
                    {{ method_field('put') }}

                    <div class="orderSummaryWrap">
                        @include('shop::public.partials.basket.view')
                        <a class="goBack"
                            href="{{ session('previous', route('shop.browse')) }}">
                                {{ trans('Continue Shopping') }}
                        </a>
                        <a href="{{ action('\\' . \Mtc\Shop\Http\Controllers\CheckoutController::class . '@customer') }}"
                                class="button right">
                            {{ trans('Proceed to Checkout') }}
                        </a>
                    </div><!-- .orderSummaryWrap -->
                </form>
            </basket>
        @endif

    </div>

@endsection
