<div id="bagItems">
    <div class="bagItemsHeader">
        <div class="bagThumb">{{ ucfirst(trans('shop::basket.product')) }}</div>
        <div class="bagDescription"></div>
        <div class="bagSize">{{ ucfirst(trans('shop::basket.variant')) }}</div>
        <div class="bagCost">{{ ucfirst(trans('shop::basket.cost')) }}</div>
    </div> <!-- .bagItemsHeader -->

    <div v-for="(line, index) in basket.items">
        @include('shop::public.partials.checkout.view_item')
    </div>

</div> <!-- #bagItems -->

<table id="totals">

    <tr class="subTotal">
        <td>{{ trans('shop::basket.subtotal') }}</td>
        <td>
            <i v-if="isLoading"
               class="fa fa-circle-o-notch fa-spin"></i>
            <span v-else
                id="basketSubTotal">
                @{{ basket.cost_subtotal | currency }}
            </span>
        </td>
    </tr>

    @if (Config::get('tax.enabled', true))
        <tr class="taxTotal">
            <td>Tax</td>
            <td>
                <i v-if="isLoading"
                   class="fa fa-circle-o-notch fa-spin"></i>
                <span v-else
                      id="basketVat">
                    @{{ basket.cost_tax | currency }}
                </span>
            </td>
        </tr>
    @endif

    <tr class="shippingTotal">
        <td>Shipping</td>
        <td>
            <i v-if="isLoading"
               class="fa fa-circle-o-notch fa-spin"></i>
            <span v-else-if="basket.shipping_method_id != null"
                  id="deliveryCosts">
                <span v-if="basket.cost_shipping > 0">
                    @{{ basket.cost_shipping | currency }}
                </span>
                <span v-else>
                    {{ trans('Free') }}
                </span>
            </span>
        </td>
    </tr>

    <tr class="checkoutTotal">
        <td>{{ trans('shop::basket.total') }}</td>
        <td>
            <i v-if="isLoading"
               class="fa fa-circle-o-notch fa-spin"></i>
            <span v-else
                  id="basketTotal">
                @{{ basket.cost_total | currency }}
            </span>
        </td>
    </tr>
</table>
