<fieldset class="personalDetails">

    {{-- Email Address --}}
    <div class="row {{ $errors->has('email') ? 'errorWrap showError' : '' }}">
        <label for="personalEmail" class="required">
            {{ trans('shop::basket.personal.email') }}
        </label>

        <input id="personalEmail"
               type="email"
               name="email"
               maxlength="75"
               aria-required="true"
               class="text"
               value="{{ old('email', $basket->email) }}"/>

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('email')])
    </div>

    {{-- Phone Number --}}
    <div class="row {{ $errors->has('phone') ? 'errorWrap showError' : '' }}">
        <label for="personalPhoneNumber" class="required">
            {{ trans('shop::basket.personal.phone_number') }}
        </label>

        <input id="personalPhoneNumber"
               type="tel"
               name="phone"
               maxlength="50"
               aria-required="true"
               class="text"
               placeholder="({{ trans('optional') }})"
               value="{{ old('phone', $basket->phone) }}"/>

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('phone')])
    </div>
</fieldset>
