<?php
/**
 *
 * PerProductDelete
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\PriceMethods\Listeners
 * @author   : Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 17/03/2017 17:08
 *
 */

namespace Mtc\Shop\PriceMethods\Listeners;

use Mtc\Shop\PriceMethods\Models\PricePerProduct;
use Mtc\Shop\Product;

/**
 * When a product is deleted:
 * Class PerProductDelete - Make sure the attendant PerProduct prices are deleted too (if there are any)
 *
 * @package Mtc\Shop
 */
class PerProductDelete
{
    /**
     * function handle
     *
     * @param Product $product
     *
     * @return void
     */
    public function handle(Product $product)
    {
        // remove all prices for this variant to avoid orphans
        PricePerProduct::where('product_id', $product->id)->delete();
    }
}
