<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class CreateStockSettingsTable
 *
 * @package Mtc\Shop\Migrations
 * @author   : Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 */
class CreateStockSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stock_settings', function(Blueprint $table) {
            $table->increments('id');
            $table->integer('stock_reserve')->default(0);
            $table->boolean('stock_notify')->default(false);
            $table->integer('stock_notify_level')->default(0);
            $table->string('stock_notify_email')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('stock_settings');
    }
}
