@if ($variants->isEmpty() == false)

    @if ($errors->any())
        @foreach($errors->all() as $error)
            <div class="alert alert-danger">
                <p>{{$error}}</p>
            </div>
        @endforeach
    @endif

    @if (config('stock.stock_enabled'))
        <form action="{{ route('shop.admin.product.stock_enable', $item) }}" method="POST">
            {{csrf_field()}}
            <div class="checkbox">
                <label>
                    <input type="hidden" name="stock_enabled" value="0">
                    <input type="checkbox"
                           name="stock_enabled"
                           value="1"
                           aria-describedby="stock_enabled_help"
                           @if (Request::old('stock_enabled', $item->stock_enabled) == 1)
                           checked
                            @endif
                    > Enable stock management for all variants?
                </label>
                <button class="btn btn-link">Update</button>
            </div>
        </form>
    @endif

    <table class="table table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Title</th>
                <th>code</th>
                <th>Stock Quantity</th>
                <th></th>
            </tr>
        </thead>

        <tbody>
        @foreach ($variants as $variant)
            <tr>
                <td>{{ $variant->id }}</td>
                <td>
                    @if (!$variant->isInStock())
                        <span class="glyphicon glyphicon-exclamation-sign error"></span>
                    @endif
                    <a href="{{ route('shop.admin.variants.edit', [$variant->product, $variant]) }}">
                        {{ $variant->node->title }}
                    </a>
                </td>
                <td>{{ $variant->code }}</td>
                <td>{{ $variant->stock_enabled || $variant->product->stock_enabled ? $variant->stock_quantity : 'N/A' }}</td>
                <td class="text-right block">
                    <div class="btn-group">
                        <a href="{{ route('shop.admin.variants.edit', [$variant->product->id, $variant->id]) }}"
                           class="btn btn-primary">
                           Edit
                        </a>
                        <delete action="{{ route('shop.admin.variants.destroy', [$variant->product->id, $variant->id]) }}"></delete>
                    </div>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
@endif

{!! $variants->render() !!}
