@extends('theme::layouts.public')

@section('head')
    <link rel="canonical" id="canonical" href="{{ $json['url'] }}" />
@endsection

@section('content')

    <browse inline-template
        v-cloak
        selected="{{ $selected }}"
        page="{{ $page }}"
        sort="{{ $sort_by }}"
    >
        <div class="productFilter">

            <div class="productSortMeta">

                <div class="triggerAdvancedProductFilterWrap">
                    <div class="triggerAdvancedProductFilterClose js_triggerAdvancedProductFilterClose button">
                        Done Filtering
                    </div> <!-- .triggerAdvancedProductFilterClose.button -->
                </div> <!-- .triggerAdvancedProductFilterWrap -->

                <div id="productFilterSort" class="filterSortForm">

                    <select class="orderby fdropdown"
                        v-model="options.sort_by"
                    >

                        <label for="sortBy">Order products by</label>

                        <option v-for="option in sortOptions"
                            :value="option.key"
                            id="sortBy"
                        >
                            @{{ option.label }}
                        </option>
                    </select>
                </div> <!-- #productFilterSort -->

                <div id="productCount">
                    @{{ products.total }} Product@{{ products.total != 1 ? 's' : '' }}
                </div> <!-- .numberOfProducts -->

            </div> <!-- .productSortMeta -->

            <div id="browse" role="main">

                <div id="productFilterTitle" class="categoryHeader"></div>

                <div id="productFilter" class="advancedFilter">
                    @include('shop::public.partials.filter')
                </div> <!-- #productFilter -->

                <div class="filterContent">
                    @include('shop::public.partials.filter_title')
                    @include('shop::public.partials.filter_content')
                </div> <!-- .filterContent -->

                <div class="browsePageContent">
                    <h2 v-if="seo_content.title">
                        @{{ seo_content.title }}
                    </h2>
                    <div class="text">
                        @{{ seo_content.description }}
                    </div>
                </div>
            </div> <!-- #browse -->
        </div>

    </browse>

@endsection

@push('pre_scripts')
    <script type="application/json" id="browseData">{!! json_encode($json) !!}</script>
@endpush
