<?php

namespace Mtc\Shop\Events;

use Mtc\Shop\Product;

/**
 * This event is triggered when the Item is being rendered.
 *
 * Used by components to register their blocks.
 */
class PriceUpdated
{
    /**
     * Store the Product model
     *
     * @var null|Product
     */
    public $product = null;

    /**
     * Store the product into the event.
     *
     * @param Product $product Product model
     *
     * @return void
     */
    public function __construct(Product $product)
    {
        $this->product = $product;
    }
}
