<?php
/**
 * StoreVariant Request
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Requests\Admin
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Determine that data for a variant is all valid before input.
 *
 * @category Mtc\Shop\Http\Requests\Admin
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class StoreVariant extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $variant = \Route::input('variant', null);

        return [
            'node.title' => 'required|max:255',
            'node.description' => 'max:255',
            'variant.code' => 'max:255',
            'variant.stock_enabled' => 'boolean',
            'variant.stock_quantity' => 'integer',
            'variant.shipping_weight' => 'numeric|min:0',
            'variant.shipping_dimensions_length' => 'numeric|min:0',
            'variant.shipping_dimensions_width' => 'numeric|min:0',
            'variant.shipping_dimensions_height' => 'numeric|min:0'
        ];
    }
}
