<?php
/**
 * Price Per Variant Form
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\PriceMethods\Listeners
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\PriceMethods\Listeners;

use Mtc\Core\Events\Admin\ItemLoading;
use Mtc\Shop\Variant;
use Mtc\Shop\PriceMethods\PerVariant;
use Mtc\Shop\PriceMethods\Models\PricePerVariant;

/**
 * Display a form on the variant page if the selected payment method is by
 * variant.
 *
 * @category Mtc\Shop\PriceMethods\Listeners
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class PerVariantForm
{
    /**
     * Load anything required - Laravel gets mad if this isn't here
     *
     * @return void
     */
    public function __construct() 
    {

    }

    /**
     * Generate and echo out the form to the browser.
     *
     * @param ItemLoading $event Incoming request
     *
     * @return void As output is returned by browser, nothing is returned by
     *              the actual method.
     */
    public function handle(ItemLoading $event)
    {
        // Don't run if this isn't the variant page.
        if (get_class($event->model) != Variant::class
            || $event->model->product->price_method != PerVariant::class
        ) {
            return;
        }

        // Now we get the prices back for this item.
        $prices = PricePerVariant::whereVariantId($event->model->id)
            ->orderBy('quantity', 'ASC')
            ->orderBy('price', 'ASC')
            ->get();

        // Echo out a view for this page.
        echo view('shop::admin.price_methods.per_variant')->with(compact('prices'));
    }
}
