<?php
/**
 * Class CreateOrderInfoTable
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class CreateOrderInfoTable
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CreateOrderInfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /*
         * Used to store the user agent info for order.
         */
        Schema::create(
            'order_info', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('order_id')->index();
                $table->string('platform');
                $table->string('platform_version');
                $table->string('browser');
                $table->string('browser_version');
                $table->string('device');
                $table->string('device_version');
                $table->string('languages');
                $table->timestamps();
            }
        );

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_info');
    }
}
