<div class="checkoutSectionWrap">
    <h3 class="shipping">{{ trans('Shipping Details') }}</h3>

    {{-- First Name --}}
    <div class="row {{ $errors->has('first_name') ? 'errorWrap showError' : '' }}">
        <label for="shippingFirstName" class="required">
            {{ trans('shop::basket.address.first_name') }}
        </label>

        <input id="shippingFirstName"
            name="addresses[shipping][first_name]"
            type="text"
            maxlength="100"
            aria-required="true"
            class="text"
            value="{{ $basket->getAddressValue('first_name', 'shipping') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.shipping.first_name')])
    </div>

    {{-- Name --}}
    <div class="row {{ $errors->has('first_name') ? 'errorWrap showError' : '' }}">
        <label for="shippingLastName" class="required">
            {{ trans('shop::basket.address.last_name') }}
        </label>

        <input id="shippingLastName"
            name="addresses[shipping][last_name]"
            type="text"
            maxlength="100"
            aria-required="true"
            class="text"
            value="{{ $basket->getAddressValue('last_name', 'shipping') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.shipping.last_name')])
    </div>

    {{-- Address (Line 1) --}}
    <div class="row {{ $errors->has('addresses.shipping.address1') ? 'errorWrap showError' : '' }}">
        <label for="shippingAddressLineOne" class="required">
            {{ trans('shop::basket.address.address1') }}
        </label>

        <input id="shippingAddressLineOne"
            name="addresses[shipping][address1]"
            type="text"
            maxlength="100"
            aria-required="true"
            class="text"
            value="{{ $basket->getAddressValue('address1', 'shipping') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.shipping.address1')])
    </div>

    {{-- Address (Line 2) --}}
    <div class="row {{ $errors->has('addresses.shipping.address2') ? 'errorWrap showError' : '' }}">
        <label for="shippingAddressLineTwo">
            {{ trans('shop::basket.address.address2') }}
        </label>

        <input id="shippingAddressLineTwo"
            name="addresses[shipping][address2]"
            type="text"
            maxlength="100"
            class="text"
            value="{{ $basket->getAddressValue('address2', 'shipping') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.shipping.address2')])
    </div>

    {{-- City --}}
    <div class="row {{ $errors->has('addresses.shipping.city') ? 'errorWrap showError' : '' }}">
        <label for="shippingCity" class="required">
            {{ trans('shop::basket.address.city') }}
        </label>

        <input id="shippingCity"
            name="addresses[shipping][city]"
            type="text"
            maxlength="100"
            class="text"
            value="{{ $basket->getAddressValue('city', 'shipping') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.shipping.city')])
    </div>

    {{-- Postcode --}}
    <div class="row {{ $errors->has('addresses.shipping.postcode') ? 'errorWrap showError' : '' }}">
        <label for="shippingPostcode" class="required">
            {{ trans('shop::basket.address.postcode') }}
        </label>

        <input id="shippingPostcode"
            name="addresses[shipping][postcode]"
            type="text"
            maxlength="20"
            class="text"
            value="{{ $basket->getAddressValue('postcode', 'shipping') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.shipping.postcode')])
    </div>

    {{-- State --}}
    <div class="row {{ $errors->has('addresses.shipping.state') ? 'errorWrap showError' : '' }}">
        <label for="shippingState">
            {{ trans('shop::basket.address.state') }}
        </label>

        <input id="shippingState"
            name="addresses[shipping][state]"
            type="text"
            maxlength="100"
            class="text"
            value="{{ $basket->getAddressValue('state', 'shipping') }}"
            >

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.shipping.state')])
    </div>

    {{-- Country --}}
    <div class="row">
        <label for="shipping" class="required">
            {{ trans('shop::basket.address.country') }}
        </label>

        <select name="addresses[shipping][country]">
            @foreach ($countries as $country)
                <option value="{{ $country->code }}"
                    {{ $country->code == $basket->getAddressValue('country', 'shipping') ? 'checked' : '' }}
                    >{{ $country->name }}</option>
                    }
            @endforeach
        </select>
    </div>

</div>
