<div class="checkoutSectionWrap">
    <h3 class="shipping">{{ trans ('Shipping Method') }}</h3>

    <ul class="deliveryOptions row {{ $errors->has('shipping_method') ? 'errorWrap showError' : '' }}">
        <li v-for="method in basket.shipping_methods"
            class="row">
            <input type="radio"
                   :id="'method' + method.id"
                   :value="method.id"
                   @change="update('change_delivery')"
                   name="shipping_method"
                   v-model="basket.shipping_method_id"/>
            <label :for="'method' + method.id">
                <span class="title">
                    @{{ method.title }}
                </span>
                <span class="cost right">
                    <span v-if="method.value > 0">
                        @{{ method.value | currency }}
                    </span>
                    <span v-else>
                        Free
                    </span>
                </span>
            </label>
        </li>

        @include('shop::public.partials.basket.error', ['errors' => $errors->get('shipping_method')])
    </ul>
</div>
