<?php
/**
 * Product Controller (Public)
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Controllers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\Controllers;

use Mtc\Core\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Shop\Product;

/**
 * Control this display of products on the public site.
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Controllers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class ProductController extends Controller
{
    /**
     * Show the product.
     *
     * @param Request $request incoming request
     * @param int $id Product ID
     *
     * @return \Illuminate\View\View
     */
    public function show(Request $request, $id)
    {
        $product = Product::with(
            [
                'media',
                'variants',
                'variants.node'
            ]
        )->find($id);

        foreach ($product->variants as $key => $variant) {
            if (!$variant->isInStock()) {
                // don't allow out of stock variants to be included
                unset($product->variants[$key]);
            }
        }

        $image = 'http://placehold.it/500x500';
        if ($product->media->isEmpty() === false) {
            $image = asset('storage/' . $product->media->first()->getSize('large'));
        }

        return view('shop::public.product')->with(compact('product', 'image'));
    }
}
