@extends('theme::layouts.public')

@section('content')

    <div id="checkout">
        <checkout basket-in="{{ $basket }}"
                  inline-template
                  v-cloak>
            <form class="checkoutForm"
                  method="post">
                {{ csrf_field() }}
                {{ method_field('post') }}

                <div class="userDetailsWrap">
                    <div id="userDetails" class="formInline">

                        @if ($basket->step === 'customer')
                            @include('shop::public.partials.checkout.customer_details')
                            @include('shop::public.partials.checkout.shipping_details')
                            <button type="submit"
                                    name="action"
                                    value="customer"
                                    class="button right checkoutButton">
                                {{ trans('Continue to Shipping Methods') }}
                            </button>
                        @elseif ($basket->step === 'shipping')
                            @include('shop::public.partials.checkout.confirmed_details')
                            @include('shop::public.partials.checkout.shipping_method')

                            <a href="{{ action('\\' . \Mtc\Shop\Http\Controllers\CheckoutController::class . '@customer') }}">
                                < {{ trans('Back to Shipping Address') }}
                            </a>
                            <button type="submit"
                                    name="action"
                                    value="shipping"
                                    class="button right checkoutButton">
                                {{ trans('Continue to Payment') }}
                            </button>
                        @elseif ($basket->step === 'payment')

                            @include('shop::public.partials.checkout.confirmed_details')
                            @include('shop::public.partials.checkout.payment_method')
                            @include('shop::public.partials.checkout.billing_details')

                            <div class="row">
                                <input type="checkbox"
                                       id="terms"
                                       :true-value="1"
                                       :false-value="0"
                                       name="terms"
                                       v-model="agreedToTerms"/>
                                <label for="terms">
                                    {{ trans('By clicking this I agree to sites Terms & Conditions') }}
                                </label>
                            </div>


                            <a href="{{ action('\\' . \Mtc\Shop\Http\Controllers\CheckoutController::class . '@shipping') }}">
                                < {{ trans('Back to Shipping Methods') }}
                            </a>
                            <button type="submit"
                                    :disabled="agreedToTerms == 0"
                                    name="action"
                                    value="payment"
                                    class="button right checkoutButton">
                                {{ trans('Complete Order') }}
                            </button>

                        @endif


                    </div> <!-- #userDetails -->
                </div><!-- .userDetailsWrap -->

                <div class="orderSummaryWrap review">
                    @include('shop::public.partials.checkout.basket')
                </div><!-- .orderSummaryWrap -->
            </form>
        </checkout>
    </div>
@endsection
