<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Tax
    |--------------------------------------------------------------------------
    |
    | Choose whether tax is applied.
    |
    */
    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Price Entry
    |--------------------------------------------------------------------------
    |
    | The option specifies whether prices are entered with or without tax. If
    | true, this means that all catalog prices are input using your store's
    | base tax rate. If false, this would mean that your catalog prices need
    | to be be tax exclusive.
    |
    */
    'price_entered_with_tax' => true,

    /*
    |--------------------------------------------------------------------------
    | Taxable Address
    |--------------------------------------------------------------------------
    |
    | Determine whether tax is shown based on customer's billing or shipping
    | address.
    |
    */
   'address' => 'shipping',

    /*
    |--------------------------------------------------------------------------
    | Rounding
    |--------------------------------------------------------------------------
    |
    | Round tax at a subtotal level, instead of rounding per line.
    |
    */
    'rounding_subtotal' => false,

    /*
    |--------------------------------------------------------------------------
    | Display Prices
    |--------------------------------------------------------------------------
    |
    | Prices should be displayed with or without tax.
    |
    */
   'display_product_tax' => true,

    /*
    |--------------------------------------------------------------------------
    | Price Display Suffix
    |--------------------------------------------------------------------------
    |
    | Allows you to change display to: “Prices include __% tax/VAT” or anything
    | appropriate for your store. You can use these two placeholders if you
    | want to have text before and after the price:
    |   - {price_including_tax}
    |   - {price_excluding_tax}
    |
    */
    'price_display_suffix' => '',

    /*
    |--------------------------------------------------------------------------
    | Tax Rates
    |--------------------------------------------------------------------------
    |
    | Rates that should be applied to countries.
    |
    */
    'rates' => [
        'Standard' => [
            [
                'name' => 'VAT',
                'country' => 'GB',
                'rate' => 0.2,
            ]
        ],
        'Reduced rate' => [
            [
                'name' => 'VAT',
                'country' => 'GB',
                'rate' => 0.05,
            ]
        ]
    ]
];
