<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBasketAddressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(
            'basket_addresses', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('basket_id')->unsigned();
                $table->enum('type', ['billing', 'shipping'])->index();

                $table->string('first_name', 100);
                $table->string('last_name', 100);
                $table->string('address1', 150);
                $table->string('address2', 150)->nullable()->default(null);
                $table->string('city', 80);
                $table->string('state', 25)->nullable()->default(null);
                $table->string('postcode', 10);
                $table->string('country', 2);

                $table->timestamps();

                $table->unique(['basket_id', 'type']);

                $table->foreign('basket_id')
                    ->references('id')
                    ->on('baskets')
                    ->onUpdate('cascade')
                    ->onDelete('cascade');
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('basket_addresses');
    }
}
