<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateShippingZonesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shipping_zones', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->text('description');
            $table->text('postcodes');
            $table->timestamps();
        });

        Schema::create('country_shipping_zone', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('country_id')->unsigned()->index();
            $table->integer('shipping_zone_id')->unsigned()->index();

            $table->foreign('country_id')
                ->references('id')
                ->on('countries')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('shipping_zone_id')
                ->references('id')
                ->on('shipping_zones')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });

        Schema::create('country_state_shipping_zone', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('country_state_id')->unsigned()->index();
            $table->integer('shipping_zone_id')->unsigned()->index();

            $table->foreign('country_state_id')
                ->references('id')
                ->on('country_states')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->foreign('shipping_zone_id')
                ->references('id')
                ->on('shipping_zones')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $tables = [
            'country_state_shipping_zone',
            'country_shipping_zone',
            'shipping_zones',
        ];

        foreach ($tables as $table) {
            Schema::dropIfExists($table);
        }
    }
}
