<?php
/**
 * Class AddDiscountTablesToBasketOrder
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class AddDiscountTablesToBasketOrder
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class AddDiscountTablesToBasketOrder extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // basket discounts
        Schema::create('basket_discounts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('basket_id')->index();
            $table->string('discount_type')->index();
            $table->integer('discount_id')->index();
            $table->timestamps();
        });

        // Order discounts
        Schema::create('order_discounts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_id')->index();
            $table->string('discount_type')->index();
            $table->integer('discount_id')->index();
            $table->string('discount_reference')->index();
            $table->integer('value');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('basket_discounts');
        Schema::dropIfExists('order_discounts');
    }
}
