<?php
/**
 * Class AddDiscountTablesToBasketOrder
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class AddDiscountTablesToBasketOrder
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class AddSurchargeTablesToBasketOrder extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // basket discounts
        Schema::create('basket_surcharges', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('basket_id')->index();
            $table->string('type')->index();
            $table->string('surcharge_type')->index();
            $table->integer('surcharge_id')->index();
            $table->string('reference')->index();
            $table->integer('value');
            $table->timestamps();
        });

        // Order discounts
        Schema::create('order_surcharges', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_id')->index();
            $table->string('surcharge_type')->index();
            $table->integer('surcharge_id')->index();
            $table->string('display_name')->index();
            $table->integer('value');
            $table->timestamps();
        });

        Schema::table('baskets', function (Blueprint $table) {
            $table->dropColumn('shipping_method_id');
            $table->dropColumn('cost_shipping');
        });

        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('shipping_method');
            $table->dropColumn('shipping_method_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('basket_surcharges');
        Schema::dropIfExists('order_surcharges');

        // Add few fields to baskets table
        Schema::table('baskets', function (Blueprint $table) {
            $table->string('shipping_method_id');
            $table->integer('cost_shipping')
                ->unsigned()
                ->nullable();
        });

        // Add few fields to orders table
        Schema::table('orders', function (Blueprint $table) {
            $table->text('shipping_method');
            $table->string('shipping_method_id');
        });
    }
}
