
function initMobileFilter()
{

    'use strict';

    var filter = $('#productFilter');

    if (filter.is(':hidden')) {
        filter.show();
        filter.data('height', filter.height());
        filter.hide();
    } else {
        filter.data('height', filter.height());
    }

}

function fixTallFilter()
{

    'use strict';

    var siteWrapper = $('.siteWrapper'),
        filter  = $('#productFilter'),
        filterHeight;

    if (filter.length > 0) {
        siteWrapper.css(
            {
                height: 'auto'
            }
        );

        filterHeight = filter.height() + filter.offset().top;

        if (filterHeight > siteWrapper.height() && filter.is(':visible')) {
            siteWrapper.height(filterHeight);
        }
    }
}

$(document).ready(
    function () {

        'use strict';

        if ($('#productFilter').length > 0) {
            initMobileFilter();
        }

        $('.productFilterButton').on(
            'click', function (e) {
                if ($(window).width() <= 800) {
                    var filterContainer = $('#productFilter'),
                    cachedThis = $(this),
                    categoryImageHeight = $('.categoryImage').is(':hidden') ? 0 : $('.categoryImage').outerHeight(),
                    thisPosition = cachedThis.outerHeight() + categoryImageHeight;

                    e.preventDefault();

                    if (filterContainer.is(':hidden')) {
                        filterContainer.fadeIn(
                            function () {
                                fixTallFilter();
                            }
                        );
                        cachedThis.addClass('open');
                        cachedThis.data('text', cachedThis.text());
                        cachedThis.text('Done');
                        filterContainer.css(
                            {
                                top: thisPosition
                            }
                        );

                    } else {
                        filterContainer.fadeOut(
                            function () {
                                fixTallFilter();
                            }
                        );
                        cachedThis.removeClass('open');
                        cachedThis.text(cachedThis.data('text'));
                    }
                }

            }
        );

        //replace the default filter section collapse

        if ($('#productFilter').length) {
            $('.collapseMe').each(
                function () {

                    var filterSortContainer = $(this).next(),
                    cachedThis = $(this);

                    cachedThis.find('i').removeClass().addClass('fa fa-angle-down');

                    if (filterSortContainer.css('display') !== 'none') {
                        cachedThis.addClass('open');
                    }

                }
            );

            $('body').off('click', '.collapseMe');

            $('body').on(
                'click', '.collapseMe', function () {
                    var filterSortContainer = $(this).next(),
                    cachedThis = $(this);

                    if (filterSortContainer.is(':hidden')) {
                        filterSortContainer.slideDown(
                            function () {
                                fixTallFilter();
                            }
                        );
                        cachedThis.addClass('open');
                    } else {
                        filterSortContainer.slideUp(
                            function () {
                                fixTallFilter();
                            }
                        );
                        cachedThis.removeClass('open');
                    }
                }
            );

        }

        $('body').on(
            'click', '.filterTrigger', function () {
                var filterSortContainer = $('.productFilterSelection'),
                cachedThis = $(this),
                thisPosition = cachedThis.height() + 20;

                if (filterSortContainer.is(':hidden')) {
                    filterSortContainer.fadeIn();
                    cachedThis.find('i').removeClass().addClass('fa fa-check');
                    cachedThis.find('a span').text('Done');
                    filterSortContainer.css(
                        {
                            top: thisPosition
                        }
                    );

                } else {
                    filterSortContainer.fadeOut();
                    cachedThis.find('i').removeClass().addClass('fa fa-bars');
                    cachedThis.find('a span').text('Refine Selection');

                }

            }
        );

    }
); // document ready

// $(window).on('resize', _.debounce(function (e) {

// /*
//  * Force strict mode
//  */

//     'use strict';

//     if ($(window).width() > 800) {
//         $('#productFilter').removeAttr('style');
//     }

//     fixTallFilter();

// }), 500); // debounce
