<div class="panel-group" id="orderSearch" role="tablist">
    <div class="panel panel-default">
        <div class="panel-heading" role="tab" id="orderSearchHeading">
            <h4 class="panel-title">
                <a role="button"
                   data-toggle="collapse"
                   data-parent="#orderSearch"
                   href="#orderSearchBody"
                   aria-expanded="false"
                   aria-controls="orderSearchBody">
                    Search
                </a>
            </h4>
        </div>

        <div id="orderSearchBody" class="panel-collapse collapse {{ Request::input('s') ? 'in' : '' }}" role="tabpanel" aria-labelledby="orderSearchHeading">

            <div class="panel-body">
                <form method="get" action="{{ route('shop.admin.orders.index') }}">

                    <input type="hidden" name="s" value="1"/>

                    <div class="form-group">
                        <label for="searchOrderStatus">Status</label>
                        <select multiple class="form-control">
                            @foreach (\Mtc\Shop\Order\OrderStatus::all() as $status)
                                <option value="{{ $status->id }}"
                                    {{ $status->id == Request::input('status') ? 'selected' : '' }}
                                    >{{ $status->title }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="searchOrderID">Order ID</label>
                        <input type="text"
                            class="form-control"
                            id="searchOrderID"
                            placeholder="Order ID"
                            name="id"
                            value="{{ Request::input('id') }}"
                            >
                    </div>

                    <div class="form-group">
                        <label for="searchCustomerName">Customer Name</label>
                        <input type="text"
                            class="form-control"
                            id="searchCustomerName"
                            placeholder="Customer Name"
                            name="name"
                            value="{{ Request::input('name') }}"
                            >
                    </div>

                    <div class="form-group">
                        <label for="searchCustomerEmail">Customer Email</label>
                        <input type="email"
                            class="form-control"
                            id="searchCustomerEmail"
                            placeholder="Customer Email"
                            name="email"
                            value="{{ Request::input('email') }}"
                            >
                    </div>

                    <input type="submit"
                        class="btn btn-primary"
                        value="Search" />
                </form>
            </div>
        </div>
    </div>
</div>
