@extends('theme::layouts.public')

@section('content')

    <div id="checkout">

        @if(! $basket->exists || $basket->items->isEmpty())
            <div class="emptyBasket">
                <h1>{{ trans('shop::basket.empty') }}</h1>
            </div>
        @else
            <basket inline-template v-cloak>
                <form class="basketForm" action="{{ route('shop.basket.update') }}" method="post">
                    {{ csrf_field() }}
                    {{ method_field('put') }}

                    <div class="basketSummaryWrap">
                        @include('shop::public.partials.basket.view')
                        <a class="goBack"
                            href="{{ session('previous', route('shop.browse')) }}">
                                {{ trans('shop::basket.back_to_browse') }}
                        </a>
                        <a href="{{ action('\\' . \Mtc\Shop\Http\Controllers\CheckoutController::class . '@customer') }}"
                                class="button right">
                            {{ trans('shop::basket.go_to_checkout') }}
                        </a>
                    </div><!-- .orderSummaryWrap -->
                </form>
            </basket>
        @endif

    </div>

@endsection
