<div class="checkoutSectionWrap">
    <h3 class="shipping">{{ trans('shop::basket.billing_details') }}</h3>

    <div class="row">
        <input type="checkbox"
               id="same_billing"
               :true-value="1"
               :false-value="0"
               @change="update('same_billing_address')"
               name="same_billing_address"
               v-model="basket.same_billing_address"/>
        <label for="same_billing">
            {{ trans('shop::basket.same_as_shipping') }}
        </label>
    </div>

    <div v-if="basket.same_billing_address == 0">

        {{-- First name --}}
        <div class="row {{ $errors->has('addresses.billing.first_name') ? 'errorWrap showError' : '' }}">
            <label for="billingFirstName" class="required">
                {{ trans('shop::basket.address.first_name') }}
            </label>

            <input id="billingFirstName"
                name="addresses[billing][first_name]"
                type="text"
                maxlength="100"
                aria-required="true"
                class="text"
                value="{{ $basket->getAddressValue('first_name', 'billing') }}"
                >

            @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.first_name')])
        </div>

        {{-- Last Name --}}
        <div class="row {{ $errors->has('addresses.billing.last_name') ? 'errorWrap showError' : '' }}">
            <label for="billingLastName">
                {{ trans('shop::basket.address.last_name') }}
            </label>

            <input id="billingLastName"
                name="addresses[billing][last_name]"
                type="text"
                maxlength="100"
                class="text"
                value="{{ $basket->getAddressValue('last_name', 'billing') }}"
            >

            @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.last_name')])
        </div>
        {{-- Address (Line 1) --}}
        <div class="row {{ $errors->has('addresses.billing.address1') ? 'errorWrap showError' : '' }}">
            <label for="billingAddressLineOne" class="required">
                {{ trans('shop::basket.address.address1') }}
            </label>

            <input id="billingAddressLineOne"
                name="addresses[billing][address1]"
                type="text"
                maxlength="100"
                aria-required="true"
                class="text"
                value="{{ $basket->getAddressValue('address1', 'billing') }}"
                >

            @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.address1')])
        </div>

        {{-- Address (Line 2) --}}
        <div class="row {{ $errors->has('addresses.billing.address2') ? 'errorWrap showError' : '' }}">
            <label for="billingAddressLineTwo">
                {{ trans('shop::basket.address.address2') }}
            </label>

            <input id="billingAddressLineTwo"
                name="addresses[billing][address2]"
                type="text"
                maxlength="100"
                class="text"
                value="{{ $basket->getAddressValue('address2', 'billing') }}"
            >

            @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.address2')])
        </div>

        {{-- City --}}
        <div class="row {{ $errors->has('addresses.billing.city') ? 'errorWrap showError' : '' }}">
            <label for="billingCity" class="required">
                {{ trans('shop::basket.address.city') }}
            </label>

            <input id="billingCity"
                name="addresses[billing][city]"
                type="text"
                maxlength="100"
                class="text"
                value="{{ $basket->getAddressValue('city', 'billing') }}"
                >

            @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.city')])
        </div>

        {{-- Postcode --}}
        <div class="row {{ $errors->has('addresses.billing.postcode') ? 'errorWrap showError' : '' }}">
            <label for="billingPostcode" class="required">
                {{ trans('shop::basket.address.postcode') }}
            </label>

            <input id="billingPostcode"
                name="addresses[billing][postcode]"
                type="text"
                maxlength="20"
                class="text"
                value="{{ $basket->getAddressValue('postcode', 'billing') }}"
                >

            @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.postcode')])
        </div>

        {{-- State --}}
        <div class="row {{ $errors->has('addresses.billing.state') ? 'errorWrap showError' : '' }}">
            <label for="billingState">
                {{ trans('shop::basket.address.state') }}
            </label>

            <input id="billingState"
                name="addresses[billing][state]"
                type="text"
                maxlength="100"
                class="text"
                value="{{ $basket->getAddressValue('state', 'billing') }}"
                >

            @include('shop::public.partials.basket.error', ['errors' => $errors->get('addresses.billing.state')])
        </div>

        {{-- Country --}}
        <div class="row">
            <label for="billingCountry" class="required">
                {{ trans('shop::basket.address.country') }}
            </label>

            <select name="addresses[billing][country]">
                @foreach ($countries as $country)
                    <option value="{{ $country->code }}"
                        {{ $country->code == $basket->getAddressValue('country', 'billing') ? 'checked' : '' }}
                        >{{ $country->name }}</option>
                        }
                @endforeach
            </select>
        </div>
    </div>

</div>
