<div id="productFilterItems">
    <ul class="itemsBrowse">
        @foreach($products as $product)
            <li class="itemSmall">
                <a href="{{$product->url}}">

                    <div class="itemImageWrap">
                        <img
                            @if($product->media->count() && env('BROWSE_IMAGES', true))
                                src="{{$product->media->first()->src}}"
                            @else
                                src="/images/default.png"
                            @endif
                            alt="{{$product->node->title}} product image"
                        />
                    </div> <!-- .itemImageWrap -->

                    <h2>
                        {{ $product->node->title }}
                    </h2>

                    <div class="itemPriceWrap">
                        <span class="priceStandard">
                            <span class="multiPrice">
                                <span class="GBP show">&pound;{{ $product->price / 100 }}</span>
                            </span>
                        </span>
                    </div> <!-- .itemPriceWrap -->

                </a>
            </li>
        @endforeach
    </ul>
</div>