<?php
/**
 * Price Modifier Abstract Class
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Abstracts
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Abstracts;

/**
 * Price Modifier Gateway Class
 *
 * Extended by individual price modifiers to change the total for
 * a basket (e.g. delivery methods, coupons, tax, etc)
 *
 * @category Mtc\Shop\Abstracts
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
abstract class PriceModifier
{
    /**
     * The name of the modifier to be displayed.
     *
     * @var string
     */
    public $title = '';

    /**
     * The type of modification taking place. e.g. delivery
     *
     * @var string
     */
    public $type = '';

    /**
     * The value of of the modification (+/-)
     *
     * @var float
     */
    public $value = 0;
}
