<?php
/**
 * Shipping Method Class.
 *
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Abstracts;

use Mtc\Shop\Contracts\BasketContract;

/**
 * Shipping Method Class.
 *
 * Extended by shipping methods to handle shipping calculations.
 *
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
abstract class ShippingMethod
{

    /**
     * The unique string ID to identify this method. e.g 'flat-rate'
     * @var string
     */
    public $id = '';

    /**
     * The human-readable name to call this shipping method.
     * @var string
     */
    public $title = '';

    /**
     * The array of rates for each method.
     * @var array
     */
    public $rates = [];

    /**
     * Calculate and retrieve rates for this method.
     *
     * @return ShippingRate[] list of shipping rates.
     */
    abstract public function calculateShipping(BasketContract $basket) : array;

}