<?php
/**
 * Basket Discount Model
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;
use Mtc\Shop\Contracts\BasketContract;

/**
 * Basket Discount class
 *
 * Stores information about the discounts applied to users basket
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class BasketDiscount extends Model
{
    /**
     * The attributes that are mass assignable
     *
     * @var array
     */
    protected $fillable = [
        'basket_id',
        'discount_type',
        'discount_id',
    ];

    /**
     * Update parent model timestamps.
     *
     * @var array
     */
    protected $touches = ['basket'];

    /**
     * Get the parent basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function basket()
    {
        return $this->belongsTo(Basket::class);
    }

    /**
     * Morph the discount to the relevant class.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function discount()
    {
        return $this->morphTo();
    }
}
