<?php
/**
 * Order Contract
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Contracts
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Contracts;

use Illuminate\Http\Request;

/**
 * This interface defines the necessary methods for building an Order
 *
 * @category Mtc\Shop\Contracts
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
interface OrderContract
{
    /**
     * Get the addresses associated with the order.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function addresses();

    /**
     * Create a new order from an existing basket
     *
     * @param BasketContract $basket Basket Model
     *
     * @return self
     */
    public function createFromBasket(BasketContract $basket);

    /**
     * Get the items associated with the order.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function items();

    /**
     * Mark the order as paid, and in the process remove
     * existing unpaid orders and basket.
     *
     * @return void
     */
    public function markPaid();

    /**
     * Get the notes associated with the order.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function notes();

    /**
     * Run a search on the incoming request.
     *
     * @param Illuminate\Eloquent\Query\Builder $query   Query Builder
     * @param Request                           $request Incoming search request
     *
     * @return Illuminate\Eloquent\Query\Builder
     */
    public function scopeBuildSearch($query, Request $request);

    /**
     * Get the associated order status.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function status();
}
