<?php
/**
 * Product Repository Contract
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Contracts
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Contracts;

use Illuminate\Http\Request;

/**
 * This interface defines the necessary methods for building a ProductRepository
 *
 * @category Mtc\Shop\Contracts
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
interface ProductRepositoryContract
{
    /**
     * Filter the results, returning a paginated list of results back.
     *
     * @param Request $request Incoming browse request
     *
     * @return \Illuminate\Contracts\Pagination\LengthAwarePaginator
     */
    public function filter(Request $request);
}
