<?php
/**
 *
 * ItemAddedToBasket Event
 *
 * PHP Version <7>
 *
 * @category Mtc\Shop\Events
 * @author   Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 11/04/2017 14:58
 *
 */

namespace Mtc\Shop\Events;

use Mtc\Shop\Basket;
use Mtc\Shop\Contracts\BasketContract;
use Mtc\Shop\Variant;


/**
 * Provide an event for actions that happen when new items are added to a basket
 *
 * @package Mtc\Shop\Events
 */
class ItemAddedToBasket
{
    /**
     * The basket the item was added to
     * @var BasketContract
     */
    public $basket;
    /**
     * The variant that was added
     * @var Variant
     */
    public $variant;
    /**
     * How many were added
     * @var int
     */
    public $quantity;

    /**
     * Build the event
     *
     * @param BasketContract $basket
     * @param Variant        $variant
     * @param int            $quantity
     */
    public function __construct(Basket $basket, Variant $variant, int $quantity)
    {
        $this->basket = $basket;
        $this->variant = $variant;
        $this->quantity = $quantity;
    }
}