<?php
/**
 * Retrieve Payment Gateways Event
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */


namespace Mtc\Shop\Events;

use Mtc\Shop\Contracts\BasketContract;

/**
 * Provide an event for components to register themselves as payment gateways
 * to be displayed during checkout.
 *
 * @category Mtc\Shop\Events
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class RetrievePaymentGateways
{
    /**
     * The basket model.
     *
     * @var null|BasketContract
     */
    public $basket = null;

    /**
     * Build the new event, adding in the order model.
     *
     * @param BasketContract $basket Incoming Basket
     *
     * @return void
     */
    public function __construct(BasketContract $basket)
    {
        $this->basket = $basket;
    }
}
