<?php
/**
 *
 * StockSettingsController
 *
 * PHP Version <7>
 *
 * @category Mtc\Shop\Http\Controllers\Admin
 * @author   Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 10/04/2017 13:04
 *
 */

namespace Mtc\Shop\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\View\View;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Shop\Product;
use Mtc\Shop\Stock\Settings as StockSettings;


/**
 * Class StockSettingsController
 *
 * @package Mtc\Shop\Http\Controllers\Admin
 */
class StockSettingsController extends Controller
{
    /**
     * Display the form for editing stock settings
     *
     * @return View
     */
    public function edit()
    {
        // create a new settings record if one does not already exist. It will be created with its defaults and
        // updated if necessary
        $stock_settings = StockSettings::firstOrCreate([]);

        return view('shop::admin.stocksettings.form')->with('stocksettings', $stock_settings);
    }

    /**
     * Store the new stock settings in the database
     *
     * @param Request $request
     *
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'stock_reserve' => 'required|numeric',
            'stock_notify'  => 'required|boolean',
            'stock_notify_level' => 'numeric|required_if:stock_notify,1',
            'stock_notify_email' => 'email|required_if:stock_notify,1'
        ]);
        $stock_settings = StockSettings::firstOrCreate([]);

        $stock_settings->stock_reserve      = $request->get('stock_reserve');
        $stock_settings->stock_notify       = $request->get('stock_notify');
        $stock_settings->stock_notify_level = $request->get('stock_notify_level');
        $stock_settings->stock_notify_email = $request->get('stock_notify_email');

        $stock_settings->save();

        Session::flash('success', 'Settings updated');

        return redirect(route('shop.admin.stocksettings.edit'));
    }

    public function updateProductStockEnable(Request $request, Product $product)
    {
        $product->stock_enabled = $request->get('stock_enabled');
        $product->save();
        return back();
    }
}