<?php
/**
 * StoreBasketInfo Request
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Requests
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Validate that the data for the basket matches what we are expecting.
 *
 * @category Mtc\Shop\Http\Requests
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class StoreBasketInfo extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'first_name' => 'required|max:100|min:3',
            'last_name' => 'required|max:100|min:3',
            'email' => 'required|email|max:75|min:5',
            'phone' => 'required|max:50|min:10',
            'addresses.billing.address1' => 'required|max:150|min:3',
            'addresses.billing.address2' => 'max:150',
            'addresses.billing.city' => 'required|max:75|min:2',
            'addresses.billing.state' => 'max:25|min:2',
            'addresses.billing.country' => 'required|max:2',
            'addresses.billing.postcode' => 'required|max:10|min:3',
            'agree_to_terms' => 'required'
        ];

        return $rules;
    }
}
