<?php
/**
 * StoreImage Request
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\Requests
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Determine that we are dealing with an uploaded image.
 *
 * @category Mtc\Shop\Http\Requests
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class StoreImage extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Check this is an image being uploaded with the name 'file'.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'file' => 'image'
        ];
    }
}
