<?php
/**
 * Baskey View Composer
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Http\ViewComposers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Http\ViewComposers;

use Illuminate\View\View;
use Mtc\Shop\Contracts\BasketContract;

/**
 * Display any data required for basket to a view.
 *
 * @category Mtc\Shop\Http\ViewComposers
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class BasketComposer
{
    /**
     * Store a copy of the basket
     *
     * @var null|BasketContract
     */
    protected $basket = null;

    /**
     * Create the view composer, attaching the basket.
     *
     * @param BasketContract $basket Basket Model
     *
     * @return void
     */
    public function __construct(BasketContract $basket)
    {
        $this->basket = $basket;
    }

    /**
     * Send the basket to the view.
     *
     * @param View $view Incoming View Object
     *
     * @return void
     */
    public function compose(View $view)
    {
        $view->with('basket', $this->basket);
    }
}
