<?php
/**
 *
 * CreateDefaultVariant
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Listeners
 * @author   Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 20/03/2017 12:43
 *
 */

namespace Mtc\Shop\Listeners;

use Illuminate\Database\Eloquent\Model;
use Mtc\Core\Node;
use Mtc\Shop\Variant;

/**
 * Class CreateDefaultVariant
 *
 * @package Mtc\Shop\Listeners
 */
class CreateDefaultVariant
{
    /**
     * function handle - create a default variant if this is the last one (meaning otherwise there would be no
     * variants for this product). Responds to the eloquent deleted event for Variant or the saved event for Product
     *
     * @param Model $model
     *
     * @return void
     */
    public function handle(Model $model)
    {
        if ($model->getTable() == 'products') {
            // a product has been saved
            $product = $model;
        } elseif ($model->getTable() == 'variants') {
            // a variant has been deleted
            if ($model->product->variants->where('id', '!=', $model->id)->count() > 0) {
                return;
            } else {
                $product = $model->product;
            }
        }
        $default_variant = new Variant(['product_id' => $product->id, 'code' => '']);
        $default_variant->default = true;
        $default_variant->save();
        $default_node = new Node([
            'title' => "Default",
            'status'=> 'published',
            'visibility'=> 'public',
            'nodeable_id' => $default_variant->id,
            'nodeable_type'=>'Mtc\\Shop\\Variant'
        ]);
        $default_variant->node()->save($default_node);
    }
}
