<?php
/**
 *
 * DeleteDefaultVariant
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Listeners
 * @author   : Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 20/03/2017 12:47
 *
 */

namespace Mtc\Shop\Listeners;

use Mtc\Shop\Variant;

/**
 * Class DeleteDefaultVariant - responds to the saved event on the Variant Model
 *
 * @package Mtc\Shop\Listeners
 */
class DeleteDefaultVariant
{
    /**
     * function handle - There's a potential default variant that could have been created before.
     * It's only needed when there are no other variants.
     * Now that we're adding a new variant we can safely delete the default one and all will be well.
     *
     * @param Variant $variant
     *
     * @return void
     */
    public function handle(Variant $variant)
    {
        if (!$variant->default) {
            Variant::where('product_id', $variant->product->id)
                ->where('default', 1)
                ->delete();
        }
    }
}
