<?php
/**
 *
 * UpdateStockQuantities
 *
 * PHP Version <7>
 *
 * @category Mtc\Shop\Listeners
 * @author   Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 12/04/2017 14:16
 *
 */

namespace Mtc\Shop\Listeners;

use Mtc\Shop\Events\OrderPaid;
use Mtc\Shop\Stock\Reserved as StockReserved;
use Mtc\Shop\Variant;


/**
 * Class UpdateStockQuantities
 *
 * @package Mtc\Shop\Listeners
 */
class UpdateStockQuantities
{
    /**
     * Handle the OrderPaid event by decrementing stock levels on all products that were purchased
     * and by removing the stockreserved records related to this basket
     *
     * @param OrderPaid $event
     *
     * @return void
     */
    public function handle(OrderPaid $event)
    {
        if (config('stock.stock_enabled')) {
            $order = $event->order;

            //remove all reserved items from this basket
            StockReserved::where('basket_id', $order->basket_id)->delete();

            // reduce the stock quantity for all the variants in this basket
            foreach ($order->items as $order_item) {
                $variant = Variant::find($order_item->variant_id);
                if ($variant->product->stock_enabled || $variant->stock_enabled) {
                    // using decrement deftly avoids being interfered with by stock_quantity's accessor
                    $variant->decrement('stock_quantity', $order_item->quantity);
                }

            }
        }

    }
}