<?php
/**
 * Order Discount Model
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Illuminate\Database\Eloquent\Model;

/**
 * Order Discount model
 *
 * Model storing information about discounts applied to item
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class OrderDiscount extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'order_id',
        'discount_type',
        'discount_id',
        'discount_reference',
        'value'
    ];

    /**
     * Get the order associated with the address.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Morph the discount to the relevant class.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function discount()
    {
        return $this->morphTo();
    }
}
