<?php
/**
 * Order Item Model
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Illuminate\Database\Eloquent\Model;

/**
 * Store items related to orders
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class OrderItem extends Model
{
    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'price' => 'float',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'order_id',
        'code',
        'product_id',
        'product_title',
        'variant_id',
        'variant_title',
        'quantity',
        'price',
    ];

    /**
     * Get the order associated with the item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(Order::class);
    }
}
