<?php
/**
 * Price Per Product Form
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\PriceMethods\Listeners
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\PriceMethods\Listeners;

use Mtc\Core\Events\Admin\ItemLoading;
use Mtc\Shop\Product;
use Mtc\Shop\PriceMethods\PerProduct;
use Mtc\Shop\PriceMethods\Models\PricePerProduct;

/**
 * Display a form on the product page if the selected price method is by
 * product.
 *
 * @category Mtc\Shop\PriceMethods\Listeners
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class PerProductForm
{
    /**
     * Load anything required - Laravel gets mad if this isn't here
     *
     * @return void
     */
    public function __construct() 
    {

    }

    /**
     * Generate and echo out the form to the browser.
     *
     * @param ItemLoading $event Incoming request
     *
     * @return void As output is returned by browser, nothing is returned by
     *              the actual method.
     */
    public function handle(ItemLoading $event)
    {
         // Don't run if this isn't the product page.
        if (get_class($event->model) != Product::class
            || $event->model->price_method != PerProduct::class
        ) {
            // Don't return false here as it stops throwing the rest of the event queue.
            return;
        }

         // Now we get the prices back for this item.
         $prices = PricePerProduct::whereProductId($event->model->id)
            ->orderBy('quantity', 'ASC')
            ->orderBy('price', 'ASC')
            ->get();

         // Echo out a view for this page.
         echo view('shop::admin.price_methods.per_product')->with(compact('prices'));
    }
}
