<?php
/**
 *
 * PerVariantDelete
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\PriceMethods\Listeners
 * @author   : Joe Pritchard <joe.pritchard@mtcmedia.co.uk>
 *
 * Created: 17/03/2017 17:08
 *
 */

namespace Mtc\Shop\PriceMethods\Listeners;

use Mtc\Core\Node;
use Mtc\Shop\PriceMethods\Models\PricePerVariant;
use Mtc\Shop\Variant;

/**
 * When a variant is deleted:
 * Class PerVariantDelete - Make sure the attendant PerVariant prices are deleted too (if there are any)
 *
 * @package Mtc\Shop
 */
class PerVariantDelete
{
    public function handle(Variant $variant)
    {
        // remove all prices for this variant to avoid orphans
        PricePerVariant::where('variant_id', $variant->id)->delete();
    }
}
