<?php
/**
 * Product Price Trait
 *
 * PHP Version 7
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop;

use Mtc\Shop\Contracts\PriceMethod;

/**
 * Product Price Trait, used in Product and Variant to introduce pricing.
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
trait Pricing
{
    /**
     * Get the base price for this variant
     *
     * @return int
     */
    public function getPriceAttribute()
    {
        return $this->prices->single()->price;
    }

    /**
     * When price is requested via $variant->pricse, return the Price Method
     * for this product.
     *
     * @throws Exception If price method if not found
     *
     * @return \Mtc\Shop\Contracts\PriceMethod
     */
    public function getPricesAttribute() : PriceMethod
    {
        // If variant, we need to get the parent.
        $product = $this->product ?: $this;
        $variant = $this->product ? $this : null;
        $price_method = $product->price_method;

        if (!class_exists($price_method)) {
            throw new \Exception("Price method not found: {$price_method}");
        }

        return new $price_method($product, $variant);
    }
}
