<?php
/**
 * Shop Discount Service Provider
 *
 * @category Mtc\Shop\Providers
 * @package  Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;

/**
 * Connect the component to Laravel
 *
 * Register all available discounts
 *
 * @category Mtc\Shop\Providers
 * @package  Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class DiscountServiceProvider extends ServiceProvider
{
    /**
     * @var string[] $registered_discount_providers List of Shop component built-in discount providers
     */
    protected static $registered_discount_providers = [];

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function boot()
    {
        $discount_providers = array_merge(
            self::$registered_discount_providers,
            array_filter(Event::fire('shop.discount_providers'))
        );
        foreach ($discount_providers as $provider) {
            if (class_exists($provider)) {
                $provider::register();
            }
        }
    }
}
