<?php
/**
 * Shipping Flat Rate Model
 *
 * PHP Version 7
 *
 * @category Mtc\Shop
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;

/**
 * Flat Rate Model
 *
 * This model represents a delivery cost that is only depending on basket cost.
 *
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class ShippingFlatRate extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'value',
        'min_basket_value',
        'max_basket_value',
        'shipping_zone_id',
    ];

    /**
     * Relationship to the shipping zone
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function zone()
    {
        return $this->belongsTo(ShippingZone::class);
    }

    /**
     * Return the price value for descriptive purposes (e.g. admin listing)
     * A method is used because some deliveries might have dynamic values calculated on the fly.
     *
     * @return
     */
    public function getDescriptivePrice()
    {
        return $this->value;
    }
}
