<?php
/**
 * Sku model
 *
 * @package  Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop;

use Illuminate\Database\Eloquent\Model;

/**
 * Sku Model
 *
 * Store information about sku for a product or different entity
 *
 * @package Mtc\Shop
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Sku extends Model
{
    /**
     * The attributes that are mass assignable
     *
     * @var array
     */
    protected $fillable = [
        'sku',
        'owner_type',
        'owner_id'
    ];

    /**
     * Get owner of this sku code
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function owner()
    {
        return $this->morphTo();
    }

    /**
     * Update stock value for sku entity
     *
     * @param int $stock new stock value
     */
    public function updateStock(int $stock)
    {
        $this->owner->stock_quantity = $stock;
        $this->owner->save();
    }

    /**
     * Static method for updating stock of a sku entity
     *
     * @param string $sku Sku code to update
     * @param int $stock stock valu
     */
    public static function updateStockForSku(string $sku, int $stock)
    {
        self::where('sku', $sku)
            ->get()
            ->each(function (self $sku) use ($stock) {
                $sku->updateStock($stock);
            });
    }

}
