@extends('theme::layouts.public')

@section('content')

    <div class="wrapper">
        <!-- Breadcrumbs include -->
    </div>

    <div class="itemWrap">
        <div class="itemBackButton">
            <a href="#"><i class="fa fa-angle-left"></i>Back</a>
        </div>

        <div class="item">
            <div class="itemDescription mobileShow">
                @include('shop::public.partials.product.title')
            </div> <!-- .itemDescription.mobileShow -->

            <div class="itemImages">
                <div class="largeImage enableZoom"
                     data-zoom-gallery="itemImage">
                    <img alt="{{ $product->node->title }}"
                         src="{{ $image }}">
                </div>

                <ul class="thumbs" data-zoom-gallery="itemImage">
                    @foreach ($product->media as $media)
                        <li>
                            <a href="{{ asset('storage/' . $media->src) }}"
                               data-large="{{ asset('storage/' . $media->src) }}"
                               class="mtcZoomGallery"
                               title="{{ $product->node->title}} Thumbnail">
                                <div class="imageWrap">
                                    <img src="{{ asset('storage/' . $media->src) }}"
                                         alt="{{ $product->node->title}} Thumbnail">
                                </div>
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>

            <div class="itemDescription">
                @include('shop::public.partials.product.title')

                <add-to-basket v-cloak
                   inline-template
                   product-in="{{ $product }}"
                   basket-title="{{ trans('shop::basket.title') }}"
                   action="{{ route('shop.basket.store') }}"><div>

                    <div v-if="product.variants.length > 1" class="row itemSizeSelectWrapper">

                        <label for="productVariant">Select Variant</label>

                        <div class="inputWrap">
                            <select id="productVariant" v-model="formData.selected">
                                <option v-for="variant in product.variants"
                                        :value="variant">
                                    @{{ variant.node.title }}
                                </option>
                            </select>
                        </div>

                    </div>

                    <div class="row quantityRow">
                        <label for="quantity">
                            <abbr title="Quantity">Qty</abbr>
                        </label>

                        <div class="inputWrap">
                            <button :disabled="formData.quantity < 2"
                                    @click="formData.quantity--">-</button>
                            <input type="tel"
                                   v-model="formData.quantity"
                                   max="999"
                                   id="quantity"
                                   class="text">
                            <button @click="formData.quantity++">+</button>
                        </div>
                    </div>

                    <div class="row addToBagRow">
                        <button id="addToBag"
                            class="button"
                            :disabled="!formData.selected"
                            @click.prevent="add()">
                            Add to {{ trans('shop::basket.title') }}
                        </button>
                    </div>

                </div></add-to-basket>

                @include('shop::public.partials.product.description')

            </div>
        </div> <!-- .item -->
    </div> <!-- .itemWrap -->

@endsection
