<?php
/**
 * Update Shop Price Listener
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Listeners
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Listeners;

use Mtc\Shop\Events\PriceUpdated;
use Mtc\Shop\Product;

/**
 * Listen out for any changes to the price and, if so, update the product's
 * sort price. Saves a great deal of time when it comes to browse execution.
 *
 * @category Mtc\Shop\Listeners
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class UpdateSortPrice
{

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param PriceUpdated $event The incoming price event, containing the product.
     *
     * @return void
     */
    public function handle(PriceUpdated $event)
    {
        // Having to use DB as otherwise the save event is triggered,
        // which causes a recursive loop.
        \DB::table($event->product->getTable())
            ->whereId($event->product->id)
            ->update(
                [
                    'sort_price' => $event->product->price->perProduct(),
                ]
            );
    }
}
