<?php
/**
 * Order Address Model
 *
 * PHP Version 7
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Order;

use Illuminate\Database\Eloquent\Model;

/**
 * Model storing information about an order's address.
 *
 * @category Mtc\Shop\Order
 * @package  Mtc\Shop
 * @author   Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 */
class OrderAddress extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'order_id',
        'type',
        'first_name',
        'last_name',
        'address1',
        'address2',
        'city',
        'state',
        'postcode',
        'country',
    ];

    /**
     * Create an event that will generate a full name and store during save.
     *
     * @return void
     */
    protected static function boot()
    {
        parent::boot();

        // We save seperately for speed as this column is indexed
        static::saving(
            function($model) {
                $model->full_name = $model->first_name . ' ' . $model->last_name;
            }
        );
    }

    /**
     * Get the order associated with the address.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(Order::class);
    }
}
